/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.vfs.impl;

import javax.annotation.CheckReturnValue;
import org.gradle.internal.snapshot.CaseSensitivity;
import org.gradle.internal.snapshot.VfsRelativePath;
import org.gradle.internal.vfs.impl.VersionHierarchy;

public class VersionHierarchyRoot {
    private final CaseSensitivity caseSensitivity;
    private final VersionHierarchy rootNode;

    public static VersionHierarchyRoot empty(long version, CaseSensitivity caseSensitivity) {
        return new VersionHierarchyRoot(VersionHierarchy.empty(version), caseSensitivity);
    }

    private VersionHierarchyRoot(VersionHierarchy rootNode, CaseSensitivity caseSensitivity) {
        this.caseSensitivity = caseSensitivity;
        this.rootNode = rootNode;
    }

    public long getVersion(String location) {
        VfsRelativePath relativePath = VfsRelativePath.of(location);
        return relativePath.isEmpty() ? this.rootNode.getMaxVersionInHierarchy() : this.rootNode.getVersion(relativePath, this.caseSensitivity);
    }

    @CheckReturnValue
    public VersionHierarchyRoot updateVersion(String location) {
        long newVersion = this.rootNode.getMaxVersionInHierarchy() + 1L;
        VfsRelativePath relativePath = VfsRelativePath.of(location);
        VersionHierarchy newRootNode = relativePath.isEmpty() ? VersionHierarchy.empty(newVersion) : this.rootNode.updateVersion(relativePath, newVersion, this.caseSensitivity);
        return new VersionHierarchyRoot(newRootNode, this.caseSensitivity);
    }
}

