/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.jvm.JavaToKotlinClassMap;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.scopes.FirPlatformClassMapper;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.JvmStandardClassIds;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0014\u0010\u0006\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0016J\u0014\u0010\f\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/FirJavaClassMapper;", "Lorg/jetbrains/kotlin/fir/scopes/FirPlatformClassMapper;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "getCorrespondingPlatformClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "Lorg/jetbrains/kotlin/name/ClassId;", "classId", "getCorrespondingKotlinClass", "classTypealiasesThatDontCauseAmbiguity", "", "getClassTypealiasesThatDontCauseAmbiguity", "()Ljava/util/Map;", "fir-jvm"})
@SourceDebugExtension(value={"SMAP\nFirJavaClassMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJavaClassMapper.kt\norg/jetbrains/kotlin/fir/resolve/FirJavaClassMapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,39:1\n1#2:40\n*E\n"})
public final class FirJavaClassMapper
extends FirPlatformClassMapper {
    @NotNull
    private final FirSession session;
    @NotNull
    private final Map<ClassId, ClassId> classTypealiasesThatDontCauseAmbiguity;

    public FirJavaClassMapper(@NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.session = session2;
        this.classTypealiasesThatDontCauseAmbiguity = MapsKt.mapOf((Pair)TuplesKt.to((Object)JvmStandardClassIds.Annotations.INSTANCE.getThrows(), (Object)JvmStandardClassIds.Annotations.INSTANCE.getThrowsAlias()));
    }

    @Override
    @Nullable
    public FirRegularClass getCorrespondingPlatformClass(@NotNull FirClassLikeDeclaration declaration) {
        FirClassLikeDeclaration firClassLikeDeclaration;
        ClassId javaClassId;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        ClassId classId = javaClassId = this.getCorrespondingPlatformClass(declaration.getSymbol().getClassId());
        if (classId != null) {
            ClassId it = classId;
            boolean bl = false;
            FirClassLikeSymbol<?> firClassLikeSymbol = FirSymbolProviderKt.getSymbolProvider(this.session).getClassLikeSymbolByClassId(it);
            firClassLikeDeclaration = firClassLikeSymbol != null ? (FirClassLikeDeclaration)firClassLikeSymbol.getFir() : null;
        } else {
            firClassLikeDeclaration = null;
        }
        FirClassLikeDeclaration firClassLikeDeclaration2 = firClassLikeDeclaration;
        return firClassLikeDeclaration2 instanceof FirRegularClass ? (FirRegularClass)firClassLikeDeclaration2 : null;
    }

    @Override
    @Nullable
    public ClassId getCorrespondingPlatformClass(@Nullable ClassId classId) {
        if (classId == null) {
            return null;
        }
        return JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(classId.asSingleFqName().toUnsafe());
    }

    @Override
    @Nullable
    public ClassId getCorrespondingKotlinClass(@Nullable ClassId classId) {
        if (classId == null) {
            return null;
        }
        return JavaToKotlinClassMap.INSTANCE.mapJavaToKotlin(classId.asSingleFqName());
    }

    @Override
    @NotNull
    public Map<ClassId, ClassId> getClassTypealiasesThatDontCauseAmbiguity() {
        return this.classTypealiasesThatDontCauseAmbiguity;
    }
}

