/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.openstreetmap.josm.actions.downloadtasks.ChangesetContentDownloadTask;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetAware;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetCacheManager;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class DownloadChangesetContentAction
extends AbstractAction {
    private final transient ChangesetAware component;

    public DownloadChangesetContentAction(ChangesetAware component) {
        CheckParameterUtil.ensureParameterNotNull(component, "component");
        this.putValue("Name", I18n.tr("Download content", new Object[0]));
        new ImageProvider("dialogs/changeset", "downloadchangesetcontent").getResource().attachImageIcon(this);
        this.putValue("ShortDescription", I18n.tr("Download the changeset content from the OSM server", new Object[0]));
        this.component = component;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (this.component.getCurrentChangeset() != null) {
            ChangesetCacheManager.getInstance().runDownloadTask(new ChangesetContentDownloadTask((Component)((Object)this.component), this.component.getCurrentChangeset().getId()));
        }
    }

    public void initProperties() {
        if (this.component.getCurrentChangeset() == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
        if (this.component.getCurrentChangeset().getContent() == null) {
            this.putValue("Name", I18n.tr("Download content", new Object[0]));
            new ImageProvider("dialogs/changeset", "downloadchangesetcontent").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Download the changeset content from the OSM server", new Object[0]));
        } else {
            this.putValue("Name", I18n.tr("Update content", new Object[0]));
            new ImageProvider("dialogs/changeset", "updatechangesetcontent").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Update the changeset content from the OSM server", new Object[0]));
        }
    }
}

